/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.HardwareEvent0405Rule;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class HardwareEvent0405RuleBase {
    private static final String TRACE_MASKT = "XPALXMLT";
    private static final String TRACE_MASKF = "XPALXMLF";
    private static final String TRACE_MASKD = "XPALXMLD";
    private ArrayList rules = new ArrayList();

    public void addRule(HardwareEvent0405Rule rule) {
        this.rules.add(rule);
    }

    public HardwareEvent0405Rule findRule(String messageNumber) {
        Trace.trace(TRACE_MASKD, "Find rule based of Key message " + messageNumber);
        HardwareEvent0405Rule returnRule = new HardwareEvent0405Rule();
        for (int i = 0; i < this.rules.size(); ++i) {
            HardwareEvent0405Rule thisRule = (HardwareEvent0405Rule)this.rules.get(i);
            if (thisRule != null) {
                Trace.trace(TRACE_MASKD, "have a rule to work with");
            } else {
                Trace.trace(TRACE_MASKD, "do not have a rule to work with");
            }
            ArrayList messagesThatMightMatch = thisRule.getMessageNumber();
            if (messagesThatMightMatch != null) {
                Trace.trace(TRACE_MASKD, "messagesThatMightMatch.size = " + messagesThatMightMatch.size());
                Trace.trace(TRACE_MASKD, "firstMessageNumber in the list = " + messagesThatMightMatch.get(0));
            } else {
                Trace.trace(TRACE_MASKD, "messagesThatMightMatch is null ");
            }
            for (int y = 0; y < messagesThatMightMatch.size(); ++y) {
                try {
                    if (Pattern.matches((String)messagesThatMightMatch.get(y), messageNumber)) {
                        return thisRule;
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "thisRule message pattern  = " + messagesThatMightMatch.get(y));
                    return null;
                }
                if (!((String)messagesThatMightMatch.get(y)).equals("none")) continue;
                returnRule = thisRule;
            }
        }
        return returnRule;
    }
}

